#!/bin/csh

nusExpand.tcl -mode bruker -sampleCount 2432 -avg -off 0 \
 -in ./ser -out ./ser_full -sample ./nuslist

bruk2pipe -verb -in ./ser_full \
  -bad 0.0 -ext -aswap -AMX -decim 1760 -dspfvs 20 -grpdly 68 -ws 8 -noi2f  \
  -xN              1024  -yN                76  -zN               256  \
  -xT               512  -yT                38  -zT               128  \
  -xMODE            DQD  -yMODE  Echo-AntiEcho  -zMODE        Complex  \
  -xSW        11363.636  -ySW         2067.722  -zSW         9601.725  \
  -xOBS         800.144  -yOBS          81.087  -zOBS         800.144  \
  -xCAR           4.677  -yCAR         118.983  -zCAR           4.677  \
  -xLAB              HN  -yLAB             15N  -zLAB              1H  \
  -ndim               3  -aq2D         Complex                         \
| nmrPipe -fn MULT -c 1.25000e+02 \
| pipe2xyz -x -out ./fid/test%03d.fid -ov

xyz2pipe -in ./fid/test%03d.fid -noWr \
| nusExpand.tcl -mask -noexpand -mode pipe -sampleCount 2432 -avg -off 0 \
  -in stdin -out ./mask/test%03d.fid -sample ./nuslist

#
# nmrDraw -process -in fid/test%03d.fid -fid fid/test%03d.fid \
#         -mask mask/test%03d.fid -sample nuslist -nus

sleep 5
