#!/bin/csh

nusExpand.tcl -mode bruker -sampleCount 1050 -avg -off 0 \
 -in ./ser -out ./ser_full -sample ./nuslist

bruk2pipe -verb -in ./ser_full \
  -bad 0.0 -ext -aswap -AMX -decim 2440 -dspfvs 21 -grpdly 76 -ws 8 -noi2f  \
  -xN              2048  -yN                84  -zN               100  \
  -xT              1024  -yT                42  -zT                50  \
  -xMODE            DQD  -yMODE        Complex  -zMODE        Complex  \
  -xSW         8196.721  -ySW        10562.595  -zSW        10562.595  \
  -xOBS         600.073  -yOBS         150.894  -zOBS         150.894  \
  -xCAR           4.773  -yCAR          43.736  -zCAR          43.736  \
  -xLAB              1H  -yLAB            13Cy  -zLAB            13Cz  \
  -ndim               3  -aq2D         Complex                         \
| nmrPipe -fn MULT -c 6.25000e+01 \
| pipe2xyz -x -out ./fid/test%03d.fid -ov

xyz2pipe -in ./fid/test%03d.fid -noWr \
| nusExpand.tcl -mask -noexpand -mode pipe -sampleCount 1050 -avg -off 0 \
  -in stdin -out ./mask/test%03d.fid -sample ./nuslist

#
# nmrDraw -process -in fid/test%03d.fid -fid fid/test%03d.fid \
#         -mask mask/test%03d.fid -sample nuslist -nus

sleep 5
