#!/bin/csh

nusExpand.tcl -mode bruker -sampleCount 448 -avg -off 0 \
 -in ./ser -out ./ser_full -sample ./nuslist

bruk2pipe -verb -in ./ser_full \
  -bad 0.0 -ext -aswap -AMX -decim 2800 -dspfvs 21 -grpdly 76 -ws 8 -noi2f  \
  -xN              1024  -yN                64  -zN               112  \
  -xT               512  -yT                32  -zT                56  \
  -xMODE            DQD  -yMODE  Echo-AntiEcho  -zMODE        Complex  \
  -xSW         7142.857  -ySW         1581.108  -zSW         3621.490  \
  -xOBS         600.073  -yOBS          60.812  -zOBS         150.896  \
  -xCAR           4.773  -yCAR         119.099  -zCAR          54.755  \
  -xLAB              HN  -yLAB             15N  -zLAB             13C  \
  -ndim               3  -aq2D         Complex                         \
| nmrPipe -fn MULT -c 7.81250e+00 \
| pipe2xyz -x -out ./fid/test%03d.fid -ov

xyz2pipe -in ./fid/test%03d.fid -noWr \
| nusExpand.tcl -mask -noexpand -mode pipe -sampleCount 448 -avg -off 0 \
  -in stdin -out ./mask/test%03d.fid -sample ./nuslist

#
# nmrDraw -process -in fid/test%03d.fid -fid fid/test%03d.fid \
#         -mask mask/test%03d.fid -sample nuslist -nus

sleep 5
