#!/bin/csh

nusExpand.tcl -mode bruker -sampleCount 1280 -avg -off 0 \
 -in ./ser -out ./ser_full -sample ./nuslist

bruk2pipe -verb -in ./ser_full \
  -bad 0.0 -ext -aswap -AMX -decim 2080 -dspfvs 20 -grpdly 68 -ws 8 -noi2f  \
  -xN              2048  -yN                80  -zN               128  \
  -xT              1024  -yT                40  -zT                64  \
  -xMODE            DQD  -yMODE  Echo-AntiEcho  -zMODE        Complex  \
  -xSW         9615.385  -ySW         1581.108  -zSW         6000.728  \
  -xOBS         600.073  -yOBS          60.812  -zOBS         600.073  \
  -xCAR           4.677  -yCAR         118.992  -zCAR           4.677  \
  -xLAB              HN  -yLAB             15N  -zLAB              1H  \
  -ndim               3  -aq2D         Complex                         \
| nmrPipe -fn MULT -c 1.25000e+02 \
| pipe2xyz -x -out ./fid/test%03d.fid -ov

xyz2pipe -in ./fid/test%03d.fid -noWr \
| nusExpand.tcl -mask -noexpand -mode pipe -sampleCount 1280 -avg -off 0 \
  -in stdin -out ./mask/test%03d.fid -sample ./nuslist

#
# nmrDraw -process -in fid/test%03d.fid -fid fid/test%03d.fid \
#         -mask mask/test%03d.fid -sample nuslist -nus

sleep 5
