#!/bin/csh -f

#
# Basic 2D Phase-Sensitive Processing:
#   Cosine-Bells are used in both dimensions.
#   Use of "ZF -auto" doubles size, then rounds to power of 2.
#   Use of "FT -auto" chooses correct Transform mode.
#   Imaginaries are deleted with "-di" in each dimension.
#   Phase corrections should be inserted by hand.

nmrPipe -in ./test.fid                       \
| nmrPipe  -fn SOL                                       \
#| nmrPipe  -fn POLY -time -verb                  \
#| nmrPipe  -fn MAC -macro $NMRTXT/ranceY.M -noRd -noWr        \
| nmrPipe  -fn SP -off 0.5 -end 1.0 -pow 2 -c 0.5      \
| nmrPipe  -fn ZF -auto                                       \
#| nmrPipe  -fn ZF -size 8192                        \
| nmrPipe  -fn ZF -zf 2                                 \
| nmrPipe  -fn FT -auto                                       \
| nmrPipe  -fn PS -p0 0.0 -p1 0.0 -di -verb                 \
#| nmrPipe  -fn EXT -x1 0.0ppm -xn 11.5ppm -sw -verb    \
#| nmrPipe  -fn EXT -x1 9.0ppm -xn 15.0ppm -sw -verb    \
#| nmrPipe  -fn EXT -x1 -1.0ppm -xn 6.5ppm -sw -verb    \
#| nmrPipe  -fn EXT -x1 1.0ppm -xn 7.5pm -sw -verb    \
| nmrPipe  -fn TP                                             \
#| nmrPipe  -fn LP -ps0-0 -verb                      \
| nmrPipe  -fn SP -off 0.5 -end 1.0 -pow 2 -c 0.5           \
| nmrPipe  -fn ZF -auto                                       \
#| nmrPipe  -fn ZF -zf 2                             \
#| nmrPipe  -fn ZF -size 32                          \
| nmrPipe  -fn ZF -size 1024                         \
| nmrPipe  -fn FT -auto                                       \
| nmrPipe  -fn PS -p0 180.0 -p1 90.0 -di -verb                   \
#| nmrPipe  -fn CS -rs 259                                     \
#| nmrPipe  -fn REV                                             \
#| nmrPipe  -fn POLY -auto -verb                  \
| nmrPipe  -fn TP                                             \
#| nmrPipe  -fn EXT -y1 0.0ppm -yn 80.0ppm -sw -verb    \
#| nmrPipe  -fn EXT -y1 110.0ppm -yn 180.0ppm -sw -verb    \
#| nmrPipe  -fn EXT -y1 -1.0ppm -yn 9.0ppm -sw -verb    \
#| nmrPipe  -fn POLY -auto -verb                  \
#| nmrPipe  -fn POLY -auto -xn 5.25ppm -verb                  \
| nmrPipe  -fn POLY -auto -x1 4.75ppm -verb                  \
   -ov -out ./test.ft2
    nmrPipe -in test.ft2 \
|pipe2xyz -nv -out RNA73hmqc.nv
