;Aws.incl.dm
;avance-version (10/07/13)
;
;$CLASS=HighRes Incl
;$COMMENT=

define loopcounter ns_orig
define delay ns_frac

define loopcounter tdlmax
define loopcounter tdl
define loopcounter tdn
define delay inf

"ns_orig = ns"
"ns_frac = 1"
;scaleByNs


subroutine qsin:aws(any ssb, loopcounter tdloop, loopcounter td)
{
  "tdlmax = larger(td-1, 1)"
  "tdl = tdloop" 
  if "ssb >= 2"
  {
    "ns_frac = ns_frac * pow(sin(((PI-(PI/ssb))*(tdl/tdlmax))+(PI/ssb)), 2)"
  }
  else
  {
    "ns_frac = ns_frac * pow(sin(PI*(tdl/tdlmax)), 2)"
  }
}

subroutine sine:aws(any ssb, loopcounter tdloop, loopcounter td)
{
  "tdlmax = larger(td-1, 1)"
  "tdl = tdloop" 
  if "ssb >= 2"
  {
    "ns_frac = ns_frac * sin(((PI-(PI/ssb))*(tdl/tdlmax))+(PI/ssb))"
  }
  else
  {
    "ns_frac = ns_frac * sin(PI*(tdl/tdlmax))"
  }
}
subroutine em:aws(any lb, loopcounter tdloop, delay incr)
{
    "tdl = tdloop"
    "inf = incr"
    "ns_frac = exp(-1*tdl*PI*incr*lb)"
}

subroutine em_to_x:aws(any x, loopcounter tdloop, loopcounter td)
{
    "tdlmax = larger(td-1, 1)"
    "tdl = tdloop"
    "ns_frac = exp((tdl/tdlmax)*log(x/ns_orig))"
}

subroutine scale_ns:aws(loopcounter mod)
{
  "ns = larger((trunc((ns_frac*ns_orig/mod)+0.5)*mod), mod)"
  "ns_frac = 1"
}

subroutine qsin_2d:aws(loopcounter mod, any ssb)
{
  "tdn = td1/2"
  subr qsin:aws(ssb, t1loop, tdn)
  subr scale_ns:aws(mod)
}

subroutine qsin_2d_qf:aws(loopcounter mod, any ssb)
{
  subr qsin:aws(ssb, t1loop, td1)
  subr scale_ns:aws(mod)
}


subroutine em_2d:aws(loopcounter mod)
{
  "tdn = td1/2"
  subr em_to_x:aws(mod, t1loop, tdn)
  subr scale_ns:aws(mod)
}

subroutine qsin_3d:aws(loopcounter mod, any ssb)
{
  "tdn = td1/2"
  subr qsin:aws(ssb, t1loop, tdn)
  "tdn = td2/2"
  subr qsin:aws(ssb, t2loop, tdn)
  subr scale_ns:aws(mod)
}

subroutine qsin_4d:aws(loopcounter mod, any ssb)
{
  "tdn = td1/2"
  subr qsin:aws(ssb, t1loop, tdn)
  "tdn = td2/2"
  subr qsin:aws(ssb, t2loop, tdn)
  "tdn = td3/2"
  subr qsin:aws(ssb, t3loop, tdn)
  subr scale_ns:aws(mod)
}
