;BB_2d_sofast_hmqc
;avance-version (13/02/28)
;SOFAST HMQC
;2D H-1/X correlation via heteronuclear zero and double quantum
;   coherence
;phase sensitive
;with decoupling during acquisition
;
;P.Schanda and B. Brutscher, J. Am. Chem. Soc. 127, 8014 (2005)
;
;$CLASS=IBS
;$DIM=2D
;$TYPE=
;$SUBTYPE=
;$COMMENT=

prosol relations=<IBS>

#include <Avance.incl>
#include <Grad.incl>
#include <Delay.incl>

define delay dNH

"d11=30m"
"d12=20u"
"dNH=1s/(cnst4*2)"


/*******************************************************************/
/*   calculation of shaped 1H pulse parameters                     */
/*******************************************************************/

;"p41=7.2/(cnst2*bf1/1000000)" /*  PC9  pulse length  */
;"spw25=plw1*(pow((cnst3/90.0)*(p1/p41)/0.125,2))" /* PC9  power level  */
;"spoff25=bf1*(cnst1/1000000)-o1"  /*  PC9  offset */
;"spoal25=0.5"

"p43=4.6/(cnst2*bf1/1000000)" /*  EBURP pulse length   */
"spw28=plw1*(pow((p1*1.04/p43)/0.06103,2))"   /* EBURP power level  */
"spw29=plw1*(pow((p1*1.04/p43)/0.06103,2))"   /* EBURP_TR power level  */
"spoff28=bf1*(cnst1/1000000)-o1" /*  EBURP offset */
;"spoal28=0"
"spoff29=bf1*(cnst1/1000000)-o1" /*  EBURP_TR offset */
;"spoal29=1.0"


;"p42=4.875/(cnst2*bf1/1000000)" /* REBURP pulse length  */
;"spw26=plw1*(pow((p1*2/p42)/0.0798,2))"   /* REBURP power level  */
;"spoff26=bf1*(cnst1/1000000)-o1" /* REBURP offset */
;"spoal26=0.5"

"p44 =p1*8.0"    /* BIP pulse length  */
"spoff30=0.0" /*  BIP offset */
"spw30=plw1"  /* BIP power level  */

/*******************************************************************/



"DELTA1=dNH-p16-d16"

"in0=inf1/2"
"d0=inf1/4-p3*2/PI-p44*0.5"

"in10=inf2/2"
"d10=inf2/4-p3*2/PI-p44*0.5"


aqseq 321

"acqt0=0"
baseopt_echo

1 ze 
  d11 pl12:f2
2 d1 do:f2
3 d12 pl2:f2
  50u UNBLKGRAD

/*******************************************************************/
/*    First SOFAST with 13C labeling (t1)                          */
/*******************************************************************/
  (p43:sp28 ph1):f1
  p16:gp1
  d16

  DELTA1
  (p3 ph3):f2
  d0
  (p44:sp30 ph2):f1
  d0
  (p3 ph4):f2
  DELTA1

  p16:gp1
  d16 
  (p44:sp30 ph2):f1
  (p43:sp29 ph1):f1

  p16:gp3
  d16
/*******************************************************************/
/*    NOE mixing, mixing time d8                                   */
/*******************************************************************/
  (p3 ph1):f2
  d8
  p16:gp4
  d16
/*******************************************************************/
/*    Second SOFAST with 13C labeling (t2)                         */
/*******************************************************************/

  (p43:sp28 ph1):f1

  p16:gp2
  d16

  DELTA1
  (p3 ph7):f2
  d10
  (p44:sp30 ph2):f1
  d10
  (p3 ph4):f2
  DELTA1
  p16:gp2
  d16 pl12:f2
  (p44:sp30 ph2):f1

  4u BLKGRAD
  go=2 ph31 cpd2:f2 
  d1 do:f2 mc #0 to 2 
  F1PH(calph(ph3, +90), caldel(d0, +in0))
  F2PH(calph(ph7, +90), caldel(d10, +in10))
exit 
  

ph1=0 
ph2=0 
ph3=0 2 
ph4=0
ph7=0 0 2 2 
ph31=0 2 2 0


;pl2 : f2 channel - power level for pulse (default)
;pl12: f2 channel - power level for CPD/BB decoupling (low power)



;sp23: f1 channel - shaped pulse 120 degree 
;                   (Pc9_4_90.1000)
;sp24: f1 channel - shaped pulse 180 degree (Reburp.1000)
;p8 : f2 channel - 180 degree shaped pulse for inversion (adiabatic)
;p16: homospoil/gradient pulse                       [1 msec]
;p21: 15N -  90 degree high power pulse
;d0 : incremented delay (2D) = in0/2-p21*4/3.1415
;d1 : relaxation delay
;d11: delay for disk I/O                             [30 msec]
;d8 NOE delay
;d12: delay for power switching                      [20 usec]
;d16: delay for homospoil/gradient recovery
;dNH : 1/(2J)NH
;cnst4: = J(NH)
;cnst1: H(N) excitation frequency (in ppm)
;cnst2: H(N) excitation band width (in ppm)
;cnst3:  PC9 flip angle
;cnst41: Power change for PC9 pulse (dB)
;cnst42: Power change for REBURP pulse (dB)
;sp26: Reburp.1000
;sp25: Pc9_4_90.1000

;inf1: 1/SW(N) = 2 * DW(N)
;in0: 1/ SW(N) = 2 * DW(N)
;nd0: 1
;ns: 2 * n
;ds: 16
;aq: <= 50 msec
;td1: number of experiments
;FnMODE: States-TPPI, TPPI, States or QSEC
;cpd3: decoupling according to sequence defined by cpdprg3: garp4.p62
;pcpd3: f3 channel - 90 degree pulse for decoupling sequence
;          use pulse of >= 350 usec


;use gradient ratio:	gp 1 : gp 2
;			  11 :    7


;for z-only gradients:
;gpz1: 11%
;gpz2:  7%

;use gradient files:   
;gpnam1: SMSQ10.100
;gpnam2: SMSQ10.100


                                          ;preprocessor-flags-start
;LABEL_CN: for C-13 and N-15 labeled samples start experiment with
;             option -DLABEL_CN (eda: ZGOPTNS)
                                          ;preprocessor-flags-end


;Processing

;PHC0(F1): 90
;PHC1(F1): -180
;FCOR(F1): 1



;$Id: sfhmqcf3gpph,v 1.10.6.2 2013/03/08 15:13:06 ber Exp $
