;IBS_C_SOFAST toto
;avance-version (13/02/28)
;BB SOFAST HMQC2
;2D H-1/X correlation via heteronuclear zero and double quantum
;   coherence
;phase sensitive
;with decoupling during acquisition
;
;P.Schanda and B. Brutscher, J. Am. Chem. Soc. 127, 8014 (2005)
;
;$CLASS=IBS
;$DIM=2D
;$TYPE=
;$SUBTYPE=
;$COMMENT=

prosol relations=<IBS>

#include <Avance.incl>
#include <Grad.incl>
#include <Delay.incl>

define delay dCH
define delay dCC
define delay dCC1
define delay dCC2
define delay dCC3
define delay dCC4

"d11=30m"
"d12=20u"
"dCH=1s/(cnst4*2)"
"dCC=1s/(2*cnst5)"  /* CT duration  */

/*******************************************************************/
/*   calculation of shaped 1H pulse parameters                     */
/*******************************************************************/



"p42=4.875/(cnst2*bf1/1000000)" /* REBURP pulse length  */
"spw26=plw1*(pow((p1*2/p42)/0.0798,2))"   /* REBURP power level  */
"spoff26=bf1*(cnst1/1000000)-o1" /* REBURP offset */
;"spoal26=0.5"

"cnst21 = 35.0"    /*  Calph  frequency offset   */
"cnst22 = 18.0"     /*  Me frequency offset   */
"p14=4.875/(70.0*bf2/1000000)" /* REBURP pulse length  */
"spoff7=bf2*((cnst21-cnst22)/1000000)" /* shift from Me to CO   */
"spw7=plw2*(pow((p3*1.97/p14)/0.0798,2))"   /* REBURP power level  */

"p44 =p1*8.0"    /* BIP pulse length  */
"spoff30=0.0" /*  BIP offset */
"spw30=plw1"  /* BIP power level  */
"p4 =p3*2.0"    /* 13C 180 pulse  */
"p2 =p1*2.0"    /* 1H 180 pulse  */

/*******************************************************************/
/*   calculation of shaped 15N pulse parameters                    */
/*******************************************************************/
"p50 =500u"    /* BIP pulse length  */
"spoff50=0.0" /*  BIP offset */
"spw50=plw3*(pow((p21*8/p50),2))"   /* BIP power level  */

/*******************************************************************/
/*	calculation of 13C decoupling																	 */
 

/* define P61 or pcpd2 350us in python 
"if ( p61 < 250u && d1 < 0.5 ) { p61 = 250u; } else { plw6=plw2*(pow((p3/p61),2)); }"
"cnst50=2000000/(4*p61*bf2)" ;GammaB1/2PI
"cnst51=cnst50*5.5" ;BW for GARP4
"cnst52=cnst50*2.2" ; BW for WALTZ65 */


"DELTA1=dCH*0.5-p16-d16-p1*0.66-p4*0.5"
"DELTA2=dCH*0.5-p16-d16-p4*0.5-p3"
"DELTA3=dCH*0.5-p16-d16-p42*0.5-p3"


"in0=inf1"
"in10=inf2/4"
"in20=inf2/4"

"d0=inf1/2-p3*0.66*2"
/*"d0=0" */ 
"d10=dCC/4-p3*0.66-p4*0.5-p16-d16"
"d20=dCC/4-p4*0.5-p2*0.5-p16-d16"
"dCC1=dCC/4-p3*0.66-p4*0.5-p16-d16"
"dCC2=dCC/4-p4*0.5-p2*0.5-p16-d16"
"dCC4=dCC/4-p3*0.66-p4*0.5-p16-d16-p1*0.33-p3*0.25+p1*0.25"
"dCC3=dCC/4-p4*0.5-p2*0.5-p16-d16-p1*0.33-p3*0.25+p1*0.25"

aqseq 312

"acqt0=0"

baseopt_echo

1 ze 
  d11 pl12:f2
2 d1 do:f2
3 d12 pl2:f2 pl3:f3
  50u UNBLKGRAD

  p16:gp5
  d16 /*fq=cnst22(bf ppm):f2  /* F2 carrier at CMe  */

/* INEPT Hy -> 2HxCz*/
  (p1 ph1):f1
  p16:gp1
  d16  

  DELTA1
 (center (p4 ph1):f2 (p2 ph1):f1)
   p16:gp1
  d16
  DELTA2
/* first CC transfer 2HxCy -> 4HzCxCz */ 
 (p3 ph3):f2
  dCC1 /* fq=cnst21(bf ppm):f2  /* F2 carrier at Calph  */
  p16:gp2
  d16
  (p4 ph5):f2
  p16:gp2
  d16
  dCC2
  (p2 ph1):f1
  dCC3
  p16:gp2
  d16
  (p4 ph5):f2
  dCC4
  p16:gp2
  d16
/* C frequency edition 4HzCzCx* */
 (center (p3 ph4):f2 (p1 ph2):f1)
   d0
 (center (p3 ph6):f2 (p1 ph2):f1)
/* back CC transfer 4HxCxCz -> 2HxCy*/ 
  d10
  p16:gp3
  d16
  (p4 ph5):f2
  p16:gp3
  d16
  d20
  (p2 ph1):f1
  d20
  p16:gp3
  d16
  (p4 ph5):f2
  d10
  p16:gp3
  d16 /* fq=cnst22(bf ppm):f2  /* F2 carrier at CMe  */
/* reverse INEPT 2HxCz -> Hy*/
 (p3 ph7):f2
  p16:gp4
  d16
	DELTA2
 (center (p4 ph1):f2 (p2 ph2):f1)
  p16:gp4
  d16 pl12:f2
  DELTA2  pl16:f3
  4u BLKGRAD
  go=2 ph31 cpd2:f2 
  d1 do:f2 mc #0 to 2 
     F1PH(calph(ph6, +90) &calph(ph7, +90), caldel(d0, +in0))
     F2PH(calph(ph7, +90), caldel(d10, -in10) &caldel(d20, +in20)) 
exit 
  

ph1=0 
ph2=1 
ph3=0 2
ph4=1 
ph6= 1 1 3 3
ph7=0
ph5=0 0 0 0 1 1 1 1
ph31=0 2 0 2 0 2 0 2


;pl3 : f2 channel - power level for pulse (default)
;pl6: f2 channel - power level for CPD/BB decoupling (low power)
;PLW12: F2 channel-power level for CPD/BB decoupling


;sp23: f1 channel - shaped pulse 120 degree 
;                   (Pc9_4_120.1000)
;sp24: f1 channel - shaped pulse 180 degree (Rsnob.1000)
;p8 : f2 channel - 180 degree shaped pulse for inversion (adiabatic)
;p16: homospoil/gradient pulse                       [1 msec]
;p3: 13C -  90 degree high power pulse
;p61: 13C decoupling pulse,> 100us
;d0 : incremented delay (2D) = in0/2-p21*4/3.1415
;d1 : relaxation delay
;d11: delay for disk I/O                             [30 msec]
;d12: delay for power switching                      [20 usec]
;d16: delay for homospoil/gradient recovery
;dNH : 1/(2J)CH
;cnst4: = J(CH)
;cnst5: = J(CC)
;cnst50: GammaB2/2PI
;cnst51: Decoupled BW with  GARP4
;cnst52: Decoupled BW with  WALTZ65
;cnst1: H(C) excitation frequency (in ppm)
;cnst2: H(C) excitation band width (in ppm)
;cnst3:  PC9 flip angle
;cnst41: Power change for PC9 pulse (dB)
;cnst42: Power change for REBURP pulse (dB)
;sp26: Reburp.1000
;sp25: Pc9_4_90.1000

;inf1: 1/SW(C) = 2 * DW(C)
;in0: 1/ SW(C) = 2 * DW(C)
;nd0: 1
;ns: 2 * n
;ds: 16
;aq: <= 50 msec
;td1: number of experiments
;FnMODE: States-TPPI, TPPI, States or QSEC
;cpd2: decoupling according to sequence defined by cpdprg3: garp4.p61
;pcpd2: f3 channel - 90 degree pulse for decoupling sequence
;          use pulse of >= 350 usec


;use gradient ratio:	gp 1 : gp 2
;			  11 :    7


;for z-only gradients:
;gpz1: 11%
;gpz2:  7%

;use gradient files:   
;gpnam1: SMSQ10.100
;gpnam2: SMSQ10.100


                                          ;preprocessor-flags-start
;LABEL_CN: for C-13 and N-15 labeled samples start experiment with
;             option -DLABEL_CN (eda: ZGOPTNS)
                                          ;preprocessor-flags-end


;Processing

;PHC0(F1): 90
;PHC1(F1): -180
;FCOR(F1): 1



;$Id: sfhmqcf3gpph,v 1.10.6.2 2013/03/08 15:13:06 ber Exp $
