;IBS_Best_HSQC_BB
;2D 1H-15N Best-HSQC
;10/12/2013
;
;(E. Lescop, P. Schanda & B. Brutscher,
;   J. Magn. Reson.  187 163-169 (2007))
;
;$CLASS=IBS
;$DIM=2D
;$TYPE=
;$SUBTYPE=
;$COMMENT=


prosol relations=<IBS>


#include <Avance.incl>
#include <Grad.incl>
#include <Delay.incl>



/******************************************************/
/*  Predefined shapes for 1H pulses       *************/
/*  cnst1: center of excitation band     **************/
/*  cnst2: excitation band width         **************/
/******************************************************/
 
/*  PC9 (p41, sp25)   */
"p41=7.2/(cnst2*bf1/1000000)" /*  PC9  pulse length  */
"spw25=plw1*(pow((p1*1.01/p41)/0.125,2))" /* PC9  power level  */
"spoff25=bf1*(cnst1/1000000)-o1"  /*  PC9  offset */
;"spoal25=0.5"

/*  REBURP (p42, sp26)   */

"p42=4.875/(cnst2*bf1/1000000)" /* REBURP pulse length  */
"spw26=plw1*(pow((p1*1.97/p42)/0.0798,2))"   /* REBURP power level  */
"spoff26=bf1*(cnst1/1000000)-o1" /* REBURP offset */
;"spoal26=1.0"

/*  EBURP & EBURP_TR  (p43, sp28, sp29)   */

"p43=4.6/(cnst2*bf1/1000000)" /*  EBURP pulse length   */
"spw28=plw1*(pow((p1*1.04/p43)/0.06103,2))"   /* EBURP power level  */
"spoff28=bf1*(cnst1/1000000)-o1" /*  EBURP offset */
;"spoal28=0"

#   ifdef INEPT
#   else
"spw29=plw1*(pow((p1*1.04/p43)/0.06103,2))"   /* EBURP power level  */
#   endif /*INEPT*/

"spoff29=bf1*(cnst1/1000000)-o1" /*  EBURP_REV offset */
;"spoal29=1.0"


"p44 =p1*8.0"    /* BIP pulse length  */
"spoff30=0.0" /*  BIP offset */
"spw30=plw1"  /* BIP power level  */


/*******************************************************************/
/*   13C Adiabatic pulse                                                        */
/*******************************************************************/

"p8=500u"       /*  Crp60,0.5,20.1 or Crp80,0.5,20.1 */
"if ( bf2 < 165 ) {spw13=plw2*(pow((p3/25.5832),2)); } else{spw13=plw2*(pow((p3/22.1557),2));} "

/*******************************************************************/
/*   calculation of shaped 15N pulse parameters                    */
/*******************************************************************/
"p50 =500u"    /* BIP pulse length  */
"spoff50=0.0" /*  BIP offset */
"spw50=plw3*(pow((p21*8/p50),2))"   /* BIP power level  */

"p51=4.875/(40*bf3/1000000)" /* REBURP pulse length  */
"spw51=plw3*(pow((p21*1.97/p51)/0.0798,2))"   /* REBURP power level  */
"spoff51=0.0"                /* REBURP offset */
;"spoal51=0.5"


/*******************************************************************/
/*   DELAYS                                                        */
/*******************************************************************/
"d11=30m"

"d25=2.6m"
"d26=2.7m"

"DELTA1=d25-p41*0.5-p42*0.5"
"DELTA2=d26-p17-d16-p42*0.5"
"DELTA3=d26-p17-d16-p43*0.5-p42*0.5"
"DELTA4=p16+d16+de+8u"

#   ifdef LABEL_CN
"DELTA=p43-d0*2-p16-d16-larger(p8,p44)"
"DELTA5=d0*2+larger(p8,p44)"
#   else
"DELTA=p43-d0*2-p16-d16-p44"
"DELTA5=d0*2+p44"
#   endif /*LABEL_CN*/

/*******************************************************************/
/*   time incremennts in 15N dimension                             */
/*******************************************************************/
"d0=3u"
"in0=inf1/2"


"acqt0=0"
baseopt_echo


1 d11 ze
2 d11 do:f3
3 10u  
  10u pl1:f1 pl2:f2 pl3:f3
  d1
  50u UNBLKGRAD
/**************************************/
/*   H-N transfer                     */
/**************************************/
  (p41:sp25 ph1)    /*  PC9  */
 
  DELTA1
  (center (p42:sp26 ph2) (p50:sp50 ph1):f3 )

  DELTA1
  (p41:sp25 ph2):f1   /*  PC9  */

  (p44:sp30 ph1)

  p16:gp4
  d16  pl3:f3
/**************************************/
/*   15N labeling                     */
/**************************************/
  (p21 ph3):f3
  (p50:sp50 ph1):f3
  d0

#   ifdef LABEL_CN
  (center (p44:sp30 ph1) (p8:sp13 ph1):f2 )
#   else
  (p44:sp30 ph1)
#   endif /*LABEL_CN*/

  d0
/**************************************/
#   ifdef INEPT
  (p50:sp50 ph1):f3
  DELTA5 pl3:f3
  (p21 ph8):f3
  p17:gp3
  d16
#   else
  p16:gp1*EA
  d16
  DELTA
  10u
  (p50:sp50 ph1):f3
  10u pl3:f3

  (p43:sp28 ph1)   /* EBURP */
  (p21 ph4):f3
#   endif /*INEPT*/


/**************************************/
/*   H-N back transfer                */
/*   INEPT version                    */
/**************************************/
#   ifdef INEPT
  (p43:sp28 ph1)   /* EBURP */
  4u 
  p17:gp6
  d16
  DELTA2
  (center (p42:sp26 ph2) (p51:sp51 ph1):f3 )
  p17:gp6
  d16  pl16:f3
  DELTA2 BLKGRAD
#   else
/**************************************/
/*   H-N back transfer                */
/*   SE version                       */
/**************************************/
  p17:gp5
  d16
  DELTA2
  (center (p42:sp26 ph1) (p51:sp51 ph1):f3 )
  DELTA2
  p17:gp5
  d16 pl3:f3
  (p21 ph5):f3
  (p43:sp29 ph2)    /* EBURP_REV  */
/**************************************/
  p17:gp6
  d16
  DELTA3
  (center (p42:sp26 ph2) (p51:sp51 ph2):f3 )
  DELTA3
  p17:gp6
  d16
  (p43:sp28 ph1)   /* EBURP */
/**************************************/
  DELTA4  
  (p42:sp26 ph1)  /* REBURP */
  p16:gp2
  d16  pl16:f3
  4u BLKGRAD
#   endif /*INEPT*/
/**************************************/
/*   Signal detection & looping       */
/**************************************/
  go=2 ph31 cpd3:f3
  d11 do:f3 mc #0 to 2 
#   ifdef INEPT
  F1PH(calph(ph8, +90), caldel(d0, +in0) & calph(ph3, +180) & calph(ph31, +180))
#   else
  F1EA(calgrad(EA) & calph(ph5, +180), caldel(d0, +in0) & calph(ph3, +180) & calph(ph31, +180))
#   endif /*INEPT*/
exit

ph1=0
ph2=1
ph3=0 2
ph4=0 0 2 2
ph5=1 1 3 3
ph6=0
ph8=0 0 2 2
ph31=0 2 2 0


;pl0 : 0W
;pl1 : f1 channel - power level for pulse (default)
;pl3 : f3 channel - power level for pulse (default)
;sp13: f2 channel - shaped pulse 180 degree (Ca and C=O, adiabatic)
;sp26: Reburp.1000
;sp25: Pc9_4_90.1000
;sp28: Eburp2.1000
;sp29: Eburp2tr.1000
;p16:  gradient pulse                         [500 us]
;p17:  gradient pulse                         [300 us]
;p21: f3 channel -  90 degree high power pulse
;p22: f3 channel - 180 degree high power pulse
;p8 : f2 channel - 180 degree shaped pulse for inversion (adiabatic)
;p29: gradient pulse 3                                 [300 usec]
;p41: PC9
;p42: REBURP
;p43: EBURP
;d0 : incremented delay (F1)                           [3 usec]
;d1 : relaxation delay; 1-5 * T1
;d11: delay for disk I/O                               [30 msec]
;d16: delay for homospoil/gradient recovery
;d25: 1/(4J(NH)                                     
;d26: 1/(4J(NH)     
;cnst1: H(N) excitation frequency (in ppm)
;cnst2: H(N) excitation band width (in ppm)
;cnst26: Call chemical shift (offset, in ppm)          [101 ppm]
;l0 FLAG: INEPT (1) SE (0)
;inf1: 1/SW(N) = 2 * DW(N)
;in0: 1/(2 * SW(N)) = DW(N)
;nd0: 2
;ns: 2 * n
;ds: >= 16
;td1: number of experiments in F1
;FnMODE: echo-antiecho in F1


;for z-only gradients:
;gpz1: 80%
;gpz2: 8.1% 
;gpz4: -30%
;gpz5: 15%
;gpz6: 11%


;use gradient files:   
;gpnam1: SMSQ10.32
;gpnam2: SMSQ10.50
;gpnam3: SMSQ10.50
;gpnam4: SMSQ10.32
;gpnam5: SMSQ10.50
;gpnam6: SMSQ10.50
;gpnam7: SMSQ10.50



