;AA_edited Met-SOFAST
;
;$CLASS=IBS
;$DIM=2D
;$TYPE=
;$SUBTYPE=
;$COMMENT=

prosol relations=<IBS>

#include <Avance.incl>
#include <Grad.incl>
#include <Delay.incl>

define delay dCH
define delay dCC

"d11=30m"
"d12=20u"
"dCH=1/(125*4)"
"dCC=1/(35*2)"


/*******************************************************************/
/*   calculation of shaped 1H pulse parameters                     */
/*******************************************************************/

"p41=7.2/(cnst2*bf1/1000000)" /*  PC9  pulse length  */
"spw25=plw1*(pow((cnst3/90.0)*(p1/p41)/0.125,2))" /* PC9  power level  */
"spoff25=bf1*(cnst1/1000000)-o1"  /*  PC9  offset */
"spoal25=0.5"

"p43=4.6/(cnst2*bf1/1000000)" /*  EBURP pulse length   */
"spw28=plw1*(pow((p1*1.04/p43)/0.06103,2))"   /* EBURP power level  */
"spw29=plw1*(pow((p1*1.04/p43)/0.06103,2))"   /* EBURP_TR power level  */
"spoff28=bf1*(cnst1/1000000)-o1" /*  EBURP offset */
"spoal28=0"
"spoff29=bf1*(cnst1/1000000)-o1" /*  EBURP_TR offset */
"spoal29=1.0"


"p42=4.875/(cnst2*bf1/1000000)" /* REBURP pulse length  */
"spw26=plw1*(pow((p1*2/p42)/0.0798,2))"   /* REBURP power level  */
"spoff26=bf1*(cnst1/1000000)-o1" /* REBURP offset */
"spoal26=0.5"

/*******************************************************************/
/*   calculation of shaped 13C pulse parameters                    */
/*******************************************************************/

"p13=4.6/(30.0*bf2/1000000)" /*  EBURP pulse length   */
"spw2=plw2*(pow((p3*1.04/p13)/0.06103,2))"   /* EBURP power level  */ 
"spw8=plw2*(pow((p3*1.04/p13)/0.06103,2))"   /* EBURP_TR power level  */
"spoal2=0"
"spoal8=1"
"spoff2=0"
"spoff8=0"

"p14=4.875/(70.0*bf2/1000000)" /* REBURP pulse length  */
"spw3=plw2*(pow((p3*1.97/p14)/0.0798,2))"   /* REBURP power level  */
"spoal3=0.5"
"spoff3=bf2*((35-15)/1000000)"  /*  shift from 15 to 35  */

"p15=4.5/(12.0*bf2/1000000)" /* ISNOB5 pulse length  */
"spw10=plw2*(pow((p3*2.0/p15)/0.0914,2))"   /* ISNOB5 power level  */
"spoff10=bf2*((cnst24-35)/1000000)"  /*  shift from 35 to 13Cdec  */
"spoal10=0"

/*******************************************************************/
"d0=0"
"in0=inf1/4"
"in31=inf1/4"
"d31=dCC*0.5-p42*0.5-p17-d16"
"DELTA2=dCC*0.5-p17-d16"

"DELTA1=dCH*2-p16-d16-p17*2-d17*2"
"DELTA3=dCH*2-p16-d16-p41*0.52"


"acqt0=0"
baseopt_echo

1 ze
2 d11 do:f2
3 d12 pl2:f2
  d1
  50u UNBLKGRAD

  p16:gp3
  d16
/**************************************/
/*   H-C transfer                     */ 
/**************************************/

  (p41:sp25 ph1):f1
  p16:gp1
  d16
  DELTA3 pl2:f2
/************************************************/
/*  13C CT editing                             **/
/************************************************/
  (p13:sp2 ph3):f2
  p17:gp4
  d17 
  DELTA2
  d0
  (p14:sp3 ph5):f2 
  p17:gp4
  d17 
  d31
  (p42:sp26 ph2):f1
  d17
  d17 
  d31
  (p14:sp3 ph0):f2 
  d17
  d17 
  DELTA2
  d0
  (p13:sp8 ph4):f2
/**************************************/
/*   H-C transfer                     */ 
/**************************************/
  p17:gp4
  d17 
  p17:gp4
  d17 
  p16:gp1
  d16 pl12:f2
  DELTA1  BLKGRAD
  go=2 ph31 cpd2:f2 
  d11 do:f2 mc #0 to 2 
     F1PH(calph(ph3, +90), caldel(d0, +in0) & caldel(d31, -in31))
exit 
  

ph0=0
ph1=0  
ph2=1 
ph3=0 2
ph4=0 
ph5=0 0 1 1 
ph31=0 2 2 0 


;pl3 : f2 channel - power level for pulse (default)
;pl6: f2 channel - power level for CPD/BB decoupling (low power)
;PLW12: F2 channel-power level for CPD/BB decoupling


;sp23: f1 channel - shaped pulse 120 degree 
;                   (Pc9_4_120.1000)
;sp24: f1 channel - shaped pulse 180 degree (Rsnob.1000)
;p8 : f2 channel - 180 degree shaped pulse for inversion (adiabatic)
;p16: homospoil/gradient pulse                       [1 msec]
;p3: 13C -  90 degree high power pulse
;p61: 13C decoupling pulse,> 100us
;d0 : incremented delay (2D) = in0/2-p21*4/3.1415
;d1 : relaxation delay
;d11: delay for disk I/O                             [30 msec]
;d12: delay for power switching                      [20 usec]
;d16: delay for homospoil/gradient recovery
;dNH : 1/(2J)CH
;cnst4: = J(CH)
;cnst50: GammaB2/2PI
;cnst51: Decoupled BW with  GARP4
;cnst52: Decoupled BW with  WALTZ65
;cnst1: H(C) excitation frequency (in ppm)
;cnst2: H(C) excitation band width (in ppm)
;cnst3:  PC9 flip angle
;cnst41: Power change for PC9 pulse (dB)
;cnst42: Power change for REBURP pulse (dB)
;sp26: Reburp.1000
;sp25: Pc9_4_90.1000

;inf1: 1/SW(C) = 2 * DW(C)
;in0: 1/ SW(C) = 2 * DW(C)
;nd0: 1
;ns: 2 * n
;ds: 16
;aq: <= 50 msec
;td1: number of experiments
;FnMODE: States-TPPI, TPPI, States or QSEC
;cpd2: decoupling according to sequence defined by cpdprg3: garp4.p61
;pcpd2: f3 channel - 90 degree pulse for decoupling sequence
;          use pulse of >= 350 usec


;use gradient ratio:	gp 1 : gp 2
;			  11 :    7


;for z-only gradients:
;gpz1: 11%
;gpz2:  7%

;use gradient files:   
;gpnam1: SMSQ10.100
;gpnam2: SMSQ10.100


                                          ;preprocessor-flags-start
;LABEL_CN: for C-13 and N-15 labeled samples start experiment with
;             option -DLABEL_CN (eda: ZGOPTNS)
                                          ;preprocessor-flags-end


;Processing

;PHC0(F1): 90
;PHC1(F1): -180
;FCOR(F1): 1



;$Id: sfhmqcf3gpph,v 1.10.6.2 2013/03/08 15:13:06 ber Exp $
