#!/bin/csh

#
# 3D States HN-Detected Processing, in-place version:


xyz2pipe -in fid/test%03d.fid -x  -verb               \
| nmrPipe  -fn SOL                                    \
| nmrPipe  -fn SP -off 0.5 -end 0.98 -pow 2 -c 0.5    \
| nmrPipe  -fn ZF                                     \
| nmrPipe  -fn FT                                     \
| nmrPipe  -fn PS -p0 -202  -p1 0.0 -di                 \
| nmrPipe  -fn EXT -left -sw                          \
| nmrPipe  -fn TP                                     \
| nmrPipe  -fn LP -fb                                 \
| nmrPipe  -fn SP -off 0.5 -end 0.98 -pow 1 -c 1.0    \
| nmrPipe  -fn ZF                                     \
| nmrPipe  -fn FT -auto                                   \
| nmrPipe  -fn PS -p0 0 -p1 0 -di                \
| nmrPipe -fn POLY -auto                                       \
| pipe2xyz -out ft/test%03d.ft3 -y -ov

xyz2pipe -in ft/test%03d.ft3 -z -verb                 \
| nmrPipe  -fn SP -off 0.5 -end 0.98 -pow 1 -c 0.5    \
| nmrPipe  -fn ZF                                     \
| nmrPipe  -fn FT -auto                                  \
| nmrPipe  -fn PS -p0 0.0 -p1 0.0 -di                 \
| pipe2xyz -out ft/test%03d.ft3 -z -ov -inPlace

proj3D.tcl -in ft/test%03d.ft3

xyz2pipe -in ft/test%03d.ft3 | nmrPipe -out trHNCA_oldC13_FPHJR_alone.ft3 -ov
